/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public final class CableHighlightRenderer {
    private CableHighlightRenderer() {
    }

    public static boolean drawHighlight(PoseStack transform, MultiBufferSource bufferSource, Camera camera, BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        Level world = camera.getEntity().getCommandSenderWorld();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() != ModRegistry.Blocks.CABLE.get() || ((CableModemVariant)((Object)state.getValue(CableBlock.MODEM))).getFacing() == null || !((Boolean)state.getValue((Property)CableBlock.CABLE)).booleanValue()) {
            return false;
        }
        VoxelShape shape = WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) ? CableShapes.getModemShape(state) : CableShapes.getCableShape(state);
        Vec3 cameraPos = camera.getPosition();
        double xOffset = (double)pos.getX() - cameraPos.x();
        double yOffset = (double)pos.getY() - cameraPos.y();
        double zOffset = (double)pos.getZ() - cameraPos.z();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f matrix4f = transform.last().pose();
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            float xDelta = (float)(x2 - x1);
            float yDelta = (float)(y2 - y1);
            float zDelta = (float)(z2 - z1);
            float len = Mth.sqrt((float)(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta));
            buffer.addVertex(matrix4f, (float)(x1 + xOffset), (float)(y1 + yOffset), (float)(z1 + zOffset)).setColor(0.0f, 0.0f, 0.0f, 0.4f).setNormal(transform.last(), xDelta /= len, yDelta /= len, zDelta /= len);
            buffer.addVertex(matrix4f, (float)(x2 + xOffset), (float)(y2 + yOffset), (float)(z2 + zOffset)).setColor(0.0f, 0.0f, 0.0f, 0.4f).setNormal(transform.last(), xDelta, yDelta, zDelta);
        });
        return true;
    }
}

